import 'package:flangapp_app/enum/action_type.dart';
import 'package:flangapp_app/models/navigation_item.dart';

import '../enum/background_mode.dart';
import '../enum/load_indicator.dart';
import '../enum/template.dart';

class Config {

  /// Generated by SiteNative {GENERATE_DATE}
  /// App UID: {APP_UID}
  /// Version: {API_SERVER}
  /// API server: {VERSION}

  /// *** App config *** ///
  // App name
  static String appName = "{APP_NAME}";
  // App link
  static String appLink = "{APP_LINK}";
  // Display page name without app name (after 1 page)
  static bool displayTitle = {APP_DISPLAY_TITLE};
  // Main color (any HEX color)
  static String color = "{APP_COLOR}";
  // Active color (any HEX color)
  static String activeColor = "{APP_ACTIVE_COLOR}";
  // Icon color color (any HEX color)
  static String iconColor = "{APP_ICON_COLOR}";
  // Title color (true - white, false - black)
  static bool isDark = {APP_COLOR_TITLE};
  // Pull to refresh enabled
  static bool pullToRefresh = {APP_PULL_TO_REFRESH};
  // User agent
  static String userAgent = "{APP_USER_AGENT}";
  // Admin email
  static String appEmail = "{APP_EMAIL}";
  // Template
  static Template appTemplate = {APP_TEMPLATE};
  // Loading indicator style
  static LoadIndicator indicator = {LOADER_INDICATOR};
  // Loading indicator color
  static String indicatorColor = "{LOADER_COLOR}";

  /// *** Access ** ///
  // Access to camera
  static bool accessCamera = {ACCESS_CAMERA};
  // Access to microphone
  static bool accessMicrophone = {ACCESS_MICROPHONE};
  // Access to geolocation
  static bool accessLocation = {ACCESS_GEOLOCATION};

  /// *** Drawer settings *** ///
  // Title
  static String drawerTitle = "{DRAWER_TITLE}";
  // Subtitle
  static String drawerSubtitle = "{DRAWER_SUBTITLE}";
  // Background mode
  static BackgroundMode drawerBackgroundMode = {DRAWER_MODE};
  // Background color (any HEX color)
  static String drawerBackgroundColor = "{DRAWER_BACKGROUND_COLOR}";
  // Title color (true - white, false - black)
  static bool drawerIsDark = {DRAWER_THEME};
  // Background image name
  static String drawerBackgroundImage = "{DRAWER_BACKGROUND_IMAGE}";
  // Logo image name
  static String drawerLogoImage = "{DRAWER_LOGO_IMAGE}";
  // Display logo
  static bool drawerIsDisplayLogo = false;

  /// *** Splashscreen settings *** ///
  // Background color (any HEX color)
  static String splashBackgroundColor = "{SPLASH_BACKGROUND_COLOR}";
  // Text color (any HEX color)
  static String splashTextColor = "{SPLASH_TEXT_COLOR}";
  // Is image background
  static bool splashIsBackgroundImage = {SPLASH_IS_IMAGE};
  // Background image name
  static String splashBackgroundImage = "{SPLASH_BACKGROUND_IMAGE}";
  // Tagline
  static String splashTagline = "{SPLASH_TAGLINE}";
  // Delay display (seconds)
  static int splashDelay = {SPLASH_DELAY};
  // Logo image name
  static String splashLogoImage = "{SPLASH_LOGO_IMAGE}";
  // Display logo
  static bool splashIsDisplayLogo = {SPLASH_LOGO_DISPLAY};

  /// *** PUSH OneSignal settings *** ///
  // App ID
  static String osAppID = "{ONESIGNAL_APP_ID}";
  // Signing
  static String osSigning = "{ONESIGNAL_SIGN}";
  // Enabled android?
  static bool osAndroidEnabled = {ONESIGNAL_ENABLED_ANDROID};

  /// *** Website styles *** ///
  // List div for hide in app
  static List<String> cssHideBlock = [{CSS_HIDE_BLOCKS}];

  /// *** Localization *** ///
  // Name offline image
  static String offlineImage = "{LOCAL_OFFLINE_IMAGE}";
  // Error internet connection (offline)
  static String messageErrorOffline = "{LOCAL_VALUE_5}";
  // Error open web page
  static String messageErrorBrowser = "{LOCAL_VALUE_6}";
  // Name error page image
  static String errorBrowserImage = "{LOCAL_ERROR_IMAGE}";
  // Title about exit from app (Android)
  static String titleExit = "{LOCAL_VALUE_2}";
  // Message about exit from app (Android)
  static String messageExit = "{LOCAL_VALUE_7}";
  // Confirm button about
  static String actionYesDownload = "{LOCAL_VALUE_3}";
  // Cancel button
  static String actionNoDownload = "{LOCAL_VALUE_4}";
  // Contact us email (About screen)
  static String contactBtn = "{LOCAL_VALUE_8}";
  // Back
  static String backBtn = "{LOCAL_VALUE_1}";

  /// *** Navigation *** ///
  // Main app navigation
  static List<NavigationItem> mainNavigation = [
    {MAIN_NAVIGATION_ARRAY}
  ];
  // Bar app navigation
  static List<NavigationItem> barNavigation = [
    {BAR_NAVIGATION_ARRAY}
  ];
  // Modal navigation
  static List<NavigationItem> modalNavigation = [
    {MODAL_NAVIGATION_ARRAY}
  ];
}